/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.impl;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public final class VisualLogger {
    private static final List<class_2561> WARNINGS = new ArrayList<class_2561>();
    private final Logger logger;
    private final Class<?> clazz;

    public VisualLogger(Class<?> clazz) {
        this.logger = LogManager.getLogger(clazz);
        this.clazz = clazz;
    }

    public void error(String message, Object ... params) {
        this.log(message, params, Level.ERROR, class_124.field_1061);
    }

    public void warn(String message, Object ... params) {
        this.log(message, params, Level.WARN, class_124.field_1065);
    }

    private void log(String message, Object[] params, Level level, class_124 formatting) {
        this.logger.log(level, message, params);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            class_2585 text = new class_2585(this.clazz.getSimpleName() + "/");
            text.method_10852((class_2561)new class_2585(level.name()).method_27692(formatting));
            text.method_10852((class_2561)new class_2585(": " + ParameterizedMessage.format((String)message, (Object[])params)));
            WARNINGS.add((class_2561)text);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void render(class_4587 matrices) {
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        int width = client.method_22683().method_4486();
        ArrayList lines = new ArrayList();
        for (class_2561 warning : WARNINGS) {
            lines.addAll(textRenderer.method_1728((class_5348)warning, width));
        }
        Objects.requireNonNull(textRenderer);
        int fontHeight = 9;
        int y = 0;
        for (class_5481 line : lines) {
            ScreenDrawing.coloredRect(matrices, 2, 2 + y, textRenderer.method_30880(line), fontHeight, -2013265920);
            ScreenDrawing.drawString(matrices, line, 2, 2 + y, -1);
            y += fontHeight;
        }
    }

    public static void reset() {
        WARNINGS.clear();
    }
}

